/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.location;

public class Coordinates {
    private double latitude = Double.NaN;
    private double longitude = Double.NaN;
    private float altitude = Float.NaN;
    public static final int DD_MM_SS = 1;
    public static final int DD_MM = 2;
    static final double ERROR = Double.NaN;
    static final int ITERATIONS = 7;
    static final double SQRT3 = 1.732050807569;
    static double PIdiv2;
    static double PIdiv4;
    static double PIdiv6;
    static double PIdiv12;
    static double PImul2;
    static double PImul4;
    static boolean isInitialised;
    static final double EARTH_RADIUS = 6378137.0;
    static final double FLATTENING = 298.257223563;
    static double lastLat1;
    static double lastLat2;
    static double lastLon1;
    static double lastLon2;
    static float calculatedDistance;
    static float calculatedAzimuth;

    public Coordinates(double d2, double d3, float f2) {
        if (Double.isNaN(d2)) {
            throw new IllegalArgumentException("Latitude " + d2 + " is not legal");
        }
        if (Double.isNaN(d3)) {
            throw new IllegalArgumentException("Longitude " + d3 + " is not legal");
        }
        if (!(d2 >= -90.0) || !(d2 <= 90.0)) {
            throw new IllegalArgumentException("Latitude " + d2 + " out of range");
        }
        this.latitude = d2;
        if (!(d3 >= -180.0) || !(d3 < 180.0)) {
            throw new IllegalArgumentException("Longitude " + d3 + " out of range");
        }
        this.longitude = d3;
        this.altitude = f2;
    }

    public double getLatitude() {
        return this.latitude;
    }

    public double getLongitude() {
        return this.longitude;
    }

    public float getAltitude() {
        return this.altitude;
    }

    public void setAltitude(float f2) {
        this.altitude = f2;
    }

    public void setLatitude(double d2) {
        if (Double.isNaN(d2)) {
            throw new IllegalArgumentException("Latitude " + d2 + " is not legal");
        }
        if (!(d2 >= -90.0) || !(d2 <= 90.0)) {
            throw new IllegalArgumentException("Latitude out of range");
        }
        this.latitude = d2;
    }

    public void setLongitude(double d2) {
        if (Double.isNaN(d2)) {
            throw new IllegalArgumentException("Longitude " + d2 + " is not legal");
        }
        if (!(d2 >= -180.0) || !(d2 < 180.0)) {
            throw new IllegalArgumentException("Longitude out of range");
        }
        this.longitude = d2;
    }

    public static double convert(String string) {
        try {
            if (string == null) {
                throw new NullPointerException("Bad coordinate string (null)");
            }
            if ((string = string.trim()).length() < 4) {
                throw new IllegalArgumentException("Bad coordinate string (len < 4)");
            }
            char c2 = string.charAt(string.length() - 1);
            if (c2 < '0' || c2 > '9') {
                throw new IllegalArgumentException("Bad coordinate string (must end with digit)");
            }
            int n2 = string.indexOf(58);
            if (n2 < 1) {
                throw new IllegalArgumentException("Bad coordinate string (no ':')");
            }
            if (n2 > 1 && string.charAt(0) == '0' || n2 > 2 && string.charAt(0) == '-' && string.charAt(1) == '0') {
                throw new IllegalArgumentException("Bad coordinate string (must not start with 0)");
            }
            int n3 = Integer.parseInt(string.substring(0, n2));
            if (n3 >= 180 || n3 < -180) {
                throw new IllegalArgumentException("Bad coordinate string (degrees out of range)");
            }
            int n4 = 1;
            if (string.startsWith("-")) {
                n4 = -1;
                n3 = -n3;
            }
            int n5 = 1;
            String string2 = null;
            int n6 = string.indexOf(58, n2 + 1);
            if (n6 < 1) {
                n5 = 2;
                n6 = string.length();
            }
            if (n5 == 2) {
                string2 = string.substring(n2 + 1, string.length());
                char c3 = string2.charAt(0);
                if (c3 < '0' || c3 > '9') {
                    throw new IllegalArgumentException("Bad coordinate string (mins must start with two digits)");
                }
                char c4 = string2.charAt(1);
                if (c4 < '0' || c4 > '9') {
                    throw new IllegalArgumentException("Bad coordinate string (mins must start with two digits)");
                }
                if (string2.length() > 8) {
                    throw new IllegalArgumentException("Bad coordinate string (mins can't have more than five decimals)");
                }
                double d2 = Double.parseDouble(string2);
                if (d2 >= 60.0 || d2 < 0.0) {
                    throw new IllegalArgumentException("Bad coordinate string");
                }
                double d3 = (double)n4 * ((double)n3 + d2 / 60.0);
                if (d3 >= 180.0 || d3 < -180.0) {
                    throw new IllegalArgumentException("Bad coordinate string");
                }
                return d3;
            }
            if (n5 == 1) {
                double d4;
                if (n6 - (n2 + 1) < 2) {
                    throw new IllegalArgumentException("Bad coordinate string (mins must have two digits)");
                }
                string2 = string.substring(n2 + 1, n6);
                char c5 = string2.charAt(0);
                if (c5 < '0' || c5 > '9') {
                    throw new IllegalArgumentException("Bad coordinate string (mins must start with two digits)");
                }
                char c6 = string2.charAt(1);
                if (c6 < '0' || c6 > '9') {
                    throw new IllegalArgumentException("Bad coordinate string (mins must start with two digits)");
                }
                int n7 = Integer.parseInt(string2);
                if (n7 > 59 || n7 < 0) {
                    throw new IllegalArgumentException("Bad coordinate string (mins out of range)");
                }
                String string3 = null;
                double d5 = 0.0;
                if (n6 != string.length()) {
                    string3 = string.substring(n6 + 1, string.length());
                    char c7 = string3.charAt(0);
                    if (c7 < '0' || c7 > '9') {
                        throw new IllegalArgumentException("Bad coordinate string (secs must start with two digits)");
                    }
                    char c8 = string3.charAt(1);
                    if (c8 < '0' || c8 > '9') {
                        throw new IllegalArgumentException("Bad coordinate string (secs must start with two digits)");
                    }
                    if (string3.length() > 6) {
                        throw new IllegalArgumentException("Bad coordinate string (secs can't have more than three decimals)");
                    }
                    d5 = Double.parseDouble(string3);
                    if (d5 >= 60.0 || d5 < 0.0) {
                        throw new IllegalArgumentException("Bad coordinate string (secs out of range)");
                    }
                }
                if ((d4 = (double)n4 * ((double)n3 + (double)n7 / 60.0 + d5 / 3600.0)) >= 180.0 || d4 < -180.0) {
                    throw new IllegalArgumentException("Bad coordinate string (result out of range)");
                }
                return d4;
            }
            throw new IllegalArgumentException("Unknown format");
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("Bad decimal number format");
        }
    }

    public static String convert(double d2, int n2) {
        if (d2 >= 180.0 || d2 < -180.0) {
            throw new IllegalArgumentException("Bad coordinate value (out of range)");
        }
        if (Double.isNaN(d2)) {
            throw new IllegalArgumentException("Bad coordinate value (NaN)");
        }
        if (n2 == 2) {
            int n3 = d2 < 0.0 ? -1 : 1;
            d2 = Math.abs(d2);
            int n4 = (int)d2;
            double d3 = (d2 - (double)n4) * 60.0;
            double d4 = (double)((int)Math.floor(10000.0 * d3 + 0.5)) / 10000.0;
            String string = (n3 < 0 ? "-" : "") + n4 + ":" + (d3 < 10.0 ? "0" : "") + d4;
            return string;
        }
        if (n2 == 1) {
            int n5 = d2 < 0.0 ? -1 : 1;
            d2 = Math.abs(d2);
            int n6 = (int)d2;
            int n7 = (int)((d2 - (double)n6) * 60.0);
            double d5 = ((d2 - (double)n6) * 60.0 - (double)n7) * 60.0;
            double d6 = (double)((int)Math.floor(100.0 * d5 + 0.5)) / 100.0;
            String string = (n5 < 0 ? "-" : "") + n6 + ":" + (n7 < 10 ? "0" : "") + n7 + ":" + (d6 < 10.0 ? "0" : "") + d6;
            return string;
        }
        throw new IllegalArgumentException("Bad outputType");
    }

    public float azimuthTo(Coordinates coordinates) {
        if (coordinates == null) {
            throw new NullPointerException();
        }
        if (lastLat1 == this.getLatitude() && lastLon1 == this.getLongitude() && lastLat2 == coordinates.getLatitude() && lastLon2 == coordinates.getLongitude()) {
            return calculatedAzimuth;
        }
        lastLat1 = this.getLatitude();
        lastLat1 = this.getLongitude();
        lastLat2 = coordinates.getLatitude();
        lastLon2 = coordinates.getLongitude();
        Coordinates.calculateDistanceAndAzimuth(this.getLatitude(), this.getLongitude(), coordinates.getLatitude(), coordinates.getLongitude());
        return calculatedAzimuth;
    }

    public float distance(Coordinates coordinates) {
        if (coordinates == null) {
            throw new NullPointerException();
        }
        if (lastLat1 == this.getLatitude() && lastLon1 == this.getLongitude() && lastLat2 == coordinates.getLatitude() && lastLon2 == coordinates.getLongitude()) {
            return calculatedDistance;
        }
        lastLat1 = this.getLatitude();
        lastLat1 = this.getLongitude();
        lastLat2 = coordinates.getLatitude();
        lastLon2 = coordinates.getLongitude();
        Coordinates.calculateDistanceAndAzimuth(this.getLatitude(), this.getLongitude(), coordinates.getLatitude(), coordinates.getLongitude());
        return calculatedDistance;
    }

    private static void init() {
        isInitialised = true;
        PIdiv2 = 1.5707963267948966;
        PIdiv4 = 0.7853981633974483;
        PIdiv6 = 0.5235987755982988;
        PIdiv12 = 0.2617993877991494;
        PImul2 = Math.PI * 2;
        PImul4 = Math.PI * 4;
    }

    private static void calculateDistanceAndAzimuth(double d2, double d3, double d4, double d5) {
        double d6 = Coordinates.toRadians(d2);
        double d7 = Coordinates.toRadians(d3);
        double d8 = Coordinates.toRadians(d4);
        double d9 = Coordinates.toRadians(d5);
        double d10 = 0.0033528106647474805;
        double d11 = 0.0;
        double d12 = 0.0;
        double d13 = 0.0;
        double d14 = 0.0;
        double d15 = 0.0;
        double d16 = 0.0;
        double d17 = 0.0;
        double d18 = 0.0;
        double d19 = 0.0;
        double d20 = 0.0;
        double d21 = 0.0;
        double d22 = 0.0;
        double d23 = 5.0E-10;
        int n2 = 1;
        int n3 = 100;
        if (d6 == d8 && (d7 == d9 || Math.abs(Math.abs(d7 - d9) - Math.PI * 2) < d23)) {
            calculatedDistance = 0.0f;
            calculatedAzimuth = 0.0f;
            return;
        }
        if (d6 + d8 == 0.0 && Math.abs(d7 - d9) == Math.PI) {
            d6 += 1.0E-5;
        }
        double d24 = 1.0 - d10;
        double d25 = d24 * Math.tan(d6);
        double d26 = d24 * Math.tan(d8);
        double d27 = 1.0 / Math.sqrt(1.0 + d25 * d25);
        double d28 = d27 * d25;
        double d29 = 1.0 / Math.sqrt(1.0 + d26 * d26);
        double d30 = d27 * d29;
        double d31 = d30 * d26;
        double d32 = d31 * d25;
        d11 = d9 - d7;
        d22 = d11 + 1.0;
        while (n2 < n3 && Math.abs(d22 - d11) > d23) {
            ++n2;
            d13 = Math.sin(d11);
            d14 = Math.cos(d11);
            d25 = d29 * d13;
            d26 = d31 - d28 * d29 * d14;
            d15 = Math.sqrt(d25 * d25 + d26 * d26);
            d16 = d30 * d14 + d32;
            d12 = Coordinates.atan2(d15, d16);
            d17 = d30 * d13 / d15;
            d18 = 1.0 - d17 * d17;
            d19 = 2.0 * d32;
            if (d18 > 0.0) {
                d19 = d16 - d19 / d18;
            }
            d20 = -1.0 + 2.0 * d19 * d19;
            d21 = ((-3.0 * d18 + 4.0) * d10 + 4.0) * d18 * d10 / 16.0;
            d22 = d11;
            d11 = ((d20 * d16 * d21 + d19) * d15 * d21 + d12) * d17;
            d11 = (1.0 - d21) * d11 * d10 + d9 - d7;
        }
        double d33 = Coordinates.mod(Coordinates.atan2(d25, d26), Math.PI * 2);
        d11 = Math.sqrt((1.0 / (d24 * d24) - 1.0) * d18 + 1.0);
        d11 += 1.0;
        d11 = (d11 - 2.0) / d11;
        d21 = (d11 * d11 / 4.0 + 1.0) / (1.0 - d11);
        d22 = (d11 * d11 * 0.375 - 1.0) * d11;
        d11 = d20 * d16;
        double d34 = ((((d15 * d15 * 4.0 - 3.0) * (1.0 - d20 - d20) * d19 * d22 / 6.0 - d11) * d22 / 4.0 + d19) * d15 * d22 + d12) * d21 * 6378137.0 * d24;
        if ((double)Math.abs(n2 - n3) < d23) {
            calculatedDistance = Float.NaN;
            calculatedAzimuth = Float.NaN;
            return;
        }
        d33 = 180.0 * d33 / Math.PI;
        calculatedDistance = (float)d34;
        calculatedAzimuth = (float)d33;
        if (d2 == 90.0) {
            calculatedAzimuth = 180.0f;
        } else if (d2 == -90.0) {
            calculatedAzimuth = 0.0f;
        }
    }

    private static double modlon(double d2) {
        return Coordinates.mod(d2 + Math.PI, Math.PI * 2) - Math.PI;
    }

    private static double modlat(double d2) {
        return Coordinates.mod(d2 + 1.5707963267948966, Math.PI * 2) - 1.5707963267948966;
    }

    private static double mod(double d2, double d3) {
        return d2 - d3 * Math.floor(d2 / d3);
    }

    private static double atan(double d2) {
        double d3;
        if (!isInitialised) {
            Coordinates.init();
        }
        boolean bl2 = false;
        boolean bl3 = false;
        int n2 = 0;
        if (d2 < 0.0) {
            d2 = -d2;
            bl2 = true;
        }
        if (d2 > 1.0) {
            d2 = 1.0 / d2;
            bl3 = true;
        }
        while (d2 > PIdiv12) {
            ++n2;
            d3 = d2 + 1.732050807569;
            d3 = 1.0 / d3;
            d2 *= 1.732050807569;
            d2 -= 1.0;
            d2 *= d3;
        }
        double d4 = d2 * d2;
        d3 = d4 + 1.4087812;
        d3 = 0.55913709 / d3;
        d3 += 0.60310579;
        d3 -= 0.05160454 * d4;
        d3 *= d2;
        while (n2 > 0) {
            d3 += PIdiv6;
            --n2;
        }
        if (bl3) {
            d3 = PIdiv2 - d3;
        }
        if (bl2) {
            d3 = -d3;
        }
        return d3;
    }

    private static double atan2(double d2, double d3) {
        if (Double.isNaN(d2) || Double.isNaN(d3)) {
            return Double.NaN;
        }
        if (d2 == 0.0 && d3 > 0.0) {
            return 0.0;
        }
        if (d2 > 0.0 && d3 == Double.POSITIVE_INFINITY) {
            return 0.0;
        }
        if (d2 == 0.0 && d3 > 0.0) {
            return 0.0;
        }
        if (d2 < 0.0 && d3 == Double.POSITIVE_INFINITY) {
            return 0.0;
        }
        if (d2 == 0.0 && d3 < 0.0) {
            return Math.PI;
        }
        if (d2 > 0.0 && d3 == Double.NEGATIVE_INFINITY) {
            return Math.PI;
        }
        if (d2 == 0.0 && d3 < 0.0) {
            return -Math.PI;
        }
        if (d2 < 0.0 && d3 == Double.NEGATIVE_INFINITY) {
            return -Math.PI;
        }
        if (d2 > 0.0 && d3 == 0.0) {
            return PIdiv2;
        }
        if (d2 == Double.POSITIVE_INFINITY && d3 != Double.POSITIVE_INFINITY && d3 != Double.NEGATIVE_INFINITY) {
            return PIdiv2;
        }
        if (d2 < 0.0 && d3 == 0.0) {
            return -PIdiv2;
        }
        if (d2 == Double.NEGATIVE_INFINITY && d3 != Double.POSITIVE_INFINITY && d3 != Double.NEGATIVE_INFINITY) {
            return -PIdiv2;
        }
        if (d2 == Double.POSITIVE_INFINITY && d3 == Double.POSITIVE_INFINITY) {
            return PIdiv4;
        }
        if (d2 == Double.POSITIVE_INFINITY && d3 == Double.NEGATIVE_INFINITY) {
            return 3.0 * PIdiv4;
        }
        if (d2 == Double.NEGATIVE_INFINITY && d3 == Double.POSITIVE_INFINITY) {
            return -PIdiv4;
        }
        if (d2 == Double.NEGATIVE_INFINITY && d3 == Double.NEGATIVE_INFINITY) {
            return -3.0 * PIdiv4;
        }
        if (d3 > 0.0) {
            return Coordinates.atan(d2 / d3);
        }
        if (d3 < 0.0) {
            return (d2 < 0.0 ? -1.0 : 1.0) * (Math.PI - Coordinates.atan(Math.abs(d2 / d3)));
        }
        return Coordinates.atan(d2 / d3);
    }

    private static double acos(double d2) {
        return PIdiv2 - Coordinates.asin(d2);
    }

    private static double asin(double d2) {
        if (d2 < -1.0 || d2 > 1.0) {
            return Double.NaN;
        }
        if (d2 == -1.0) {
            return -PIdiv2;
        }
        if (d2 == 1.0) {
            return PIdiv2;
        }
        return Coordinates.atan(d2 / Math.sqrt(1.0 - d2 * d2));
    }

    private static double pow2(double d2) {
        return d2 * d2;
    }

    private static double toDegrees(double d2) {
        return d2 * 360.0 / (Math.PI * 2);
    }

    private static double toRadians(double d2) {
        return d2 * (Math.PI * 2) / 360.0;
    }

    static {
        isInitialised = false;
        lastLat1 = Double.NaN;
        lastLat2 = Double.NaN;
        lastLon1 = Double.NaN;
        lastLon2 = Double.NaN;
        calculatedDistance = Float.NaN;
        calculatedAzimuth = Float.NaN;
    }
}

