/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.location;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import javax.microedition.location.AddressInfo;
import javax.microedition.location.QualifiedCoordinates;

public class Landmark {
    private String name;
    private String description;
    private QualifiedCoordinates coordinates;
    private AddressInfo addressInfo;
    private int id = -1;
    private int storeId = -1;
    private long categoryBitfield = 0L;

    public Landmark(String string, String string2, QualifiedCoordinates qualifiedCoordinates, AddressInfo addressInfo) {
        if (string == null) {
            throw new NullPointerException("Landmark name must not be null");
        }
        this.name = string;
        this.description = string2;
        this.coordinates = qualifiedCoordinates;
        this.addressInfo = addressInfo;
        this.id = -1;
        this.storeId = -1;
        this.categoryBitfield = 0L;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public QualifiedCoordinates getQualifiedCoordinates() {
        return this.coordinates;
    }

    public AddressInfo getAddressInfo() {
        return this.addressInfo;
    }

    public void setName(String string) {
        if (string == null) {
            throw new NullPointerException("Landmark name must not be null");
        }
        this.name = string;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public void setQualifiedCoordinates(QualifiedCoordinates qualifiedCoordinates) {
        this.coordinates = qualifiedCoordinates;
    }

    public void setAddressInfo(AddressInfo addressInfo) {
        this.addressInfo = addressInfo;
    }

    void setId(int n2) {
        this.id = n2;
    }

    int getId() {
        return this.id;
    }

    void setStoreId(int n2) {
        this.storeId = n2;
    }

    int getStoreId() {
        return this.storeId;
    }

    void setCategoryBits(long l2) {
        this.categoryBitfield = l2;
    }

    long getCategoryBits() {
        return this.categoryBitfield;
    }

    byte[] getBytes() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            Object object;
            if (this.name != null) {
                dataOutputStream.writeUTF(this.name);
            } else {
                dataOutputStream.writeUTF("null");
            }
            dataOutputStream.writeLong(this.categoryBitfield);
            if (this.description != null) {
                dataOutputStream.writeUTF(this.description);
            } else {
                dataOutputStream.writeUTF("null");
            }
            if (this.coordinates != null) {
                dataOutputStream.writeDouble(this.coordinates.getLatitude());
                dataOutputStream.writeDouble(this.coordinates.getLongitude());
                dataOutputStream.writeFloat(this.coordinates.getAltitude());
                dataOutputStream.writeFloat(this.coordinates.getHorizontalAccuracy());
                dataOutputStream.writeFloat(this.coordinates.getVerticalAccuracy());
            } else {
                dataOutputStream.writeDouble(Double.NaN);
                dataOutputStream.writeDouble(Double.NaN);
                dataOutputStream.writeFloat(Float.NaN);
                dataOutputStream.writeFloat(Float.NaN);
                dataOutputStream.writeFloat(Float.NaN);
            }
            if (this.addressInfo != null) {
                object = this.addressInfo.getField(1);
                String string = this.addressInfo.getField(2);
                String string2 = this.addressInfo.getField(3);
                String string3 = this.addressInfo.getField(4);
                String string4 = this.addressInfo.getField(5);
                String string5 = this.addressInfo.getField(9);
                String string6 = this.addressInfo.getField(6);
                String string7 = this.addressInfo.getField(7);
                String string8 = this.addressInfo.getField(8);
                String string9 = this.addressInfo.getField(10);
                String string10 = this.addressInfo.getField(11);
                String string11 = this.addressInfo.getField(12);
                String string12 = this.addressInfo.getField(13);
                String string13 = this.addressInfo.getField(14);
                String string14 = this.addressInfo.getField(15);
                String string15 = this.addressInfo.getField(16);
                String string16 = this.addressInfo.getField(17);
                String string17 = "";
                dataOutputStream.writeUTF((String)(object != null ? object : string17));
                dataOutputStream.writeUTF(string != null ? string : string17);
                dataOutputStream.writeUTF(string2 != null ? string2 : string17);
                dataOutputStream.writeUTF(string3 != null ? string3 : string17);
                dataOutputStream.writeUTF(string4 != null ? string4 : string17);
                dataOutputStream.writeUTF(string5 != null ? string5 : string17);
                dataOutputStream.writeUTF(string6 != null ? string6 : string17);
                dataOutputStream.writeUTF(string7 != null ? string7 : string17);
                dataOutputStream.writeUTF(string8 != null ? string8 : string17);
                dataOutputStream.writeUTF(string9 != null ? string9 : string17);
                dataOutputStream.writeUTF(string10 != null ? string10 : string17);
                dataOutputStream.writeUTF(string11 != null ? string11 : string17);
                dataOutputStream.writeUTF(string12 != null ? string12 : string17);
                dataOutputStream.writeUTF(string13 != null ? string13 : string17);
                dataOutputStream.writeUTF(string14 != null ? string14 : string17);
                dataOutputStream.writeUTF(string15 != null ? string15 : string17);
                dataOutputStream.writeUTF(string16 != null ? string16 : string17);
            } else {
                object = "";
                int n2 = 0;
                while (n2 < 17) {
                    dataOutputStream.writeUTF((String)object);
                    ++n2;
                }
            }
            object = byteArrayOutputStream.toByteArray();
            if (dataOutputStream != null) {
                dataOutputStream.close();
                dataOutputStream = null;
            }
            if (byteArrayOutputStream != null) {
                byteArrayOutputStream.close();
                byteArrayOutputStream = null;
            }
            return object;
        }
        catch (IOException iOException) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    Landmark(byte[] byArray) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
        String string = null;
        try {
            this.name = dataInputStream.readUTF();
            if ("null".equals(this.name)) {
                this.name = null;
            }
            this.categoryBitfield = dataInputStream.readLong();
            this.description = dataInputStream.readUTF();
            if ("null".equals(this.description)) {
                this.description = null;
            }
            double d2 = dataInputStream.readDouble();
            double d3 = dataInputStream.readDouble();
            float f2 = dataInputStream.readFloat();
            float f3 = dataInputStream.readFloat();
            float f4 = dataInputStream.readFloat();
            this.coordinates = !Double.isNaN(d2) && !Double.isNaN(d3) ? new QualifiedCoordinates(d2, d3, f2, f3, f4) : null;
            this.addressInfo = new AddressInfo();
            String string2 = "";
            boolean bl2 = false;
            string = dataInputStream.readUTF();
            string = !string2.equals(string) ? string : null;
            bl2 = bl2 || string != null;
            this.addressInfo.setField(1, string);
            string = dataInputStream.readUTF();
            string = !string2.equals(string) ? string : null;
            bl2 = bl2 || string != null;
            this.addressInfo.setField(2, string);
            string = dataInputStream.readUTF();
            string = !string2.equals(string) ? string : null;
            bl2 = bl2 || string != null;
            this.addressInfo.setField(3, string);
            string = dataInputStream.readUTF();
            string = !string2.equals(string) ? string : null;
            bl2 = bl2 || string != null;
            this.addressInfo.setField(4, string);
            string = dataInputStream.readUTF();
            string = !string2.equals(string) ? string : null;
            bl2 = bl2 || string != null;
            this.addressInfo.setField(5, string);
            string = dataInputStream.readUTF();
            string = !string2.equals(string) ? string : null;
            bl2 = bl2 || string != null;
            this.addressInfo.setField(9, string);
            string = dataInputStream.readUTF();
            string = !string2.equals(string) ? string : null;
            bl2 = bl2 || string != null;
            this.addressInfo.setField(6, string);
            string = dataInputStream.readUTF();
            string = !string2.equals(string) ? string : null;
            bl2 = bl2 || string != null;
            this.addressInfo.setField(7, string);
            string = dataInputStream.readUTF();
            string = !string2.equals(string) ? string : null;
            bl2 = bl2 || string != null;
            this.addressInfo.setField(8, string);
            string = dataInputStream.readUTF();
            string = !string2.equals(string) ? string : null;
            bl2 = bl2 || string != null;
            this.addressInfo.setField(10, string);
            string = dataInputStream.readUTF();
            string = !string2.equals(string) ? string : null;
            bl2 = bl2 || string != null;
            this.addressInfo.setField(11, string);
            string = dataInputStream.readUTF();
            string = !string2.equals(string) ? string : null;
            bl2 = bl2 || string != null;
            this.addressInfo.setField(12, string);
            string = dataInputStream.readUTF();
            string = !string2.equals(string) ? string : null;
            bl2 = bl2 || string != null;
            this.addressInfo.setField(13, string);
            string = dataInputStream.readUTF();
            string = !string2.equals(string) ? string : null;
            bl2 = bl2 || string != null;
            this.addressInfo.setField(14, string);
            string = dataInputStream.readUTF();
            string = !string2.equals(string) ? string : null;
            bl2 = bl2 || string != null;
            this.addressInfo.setField(15, string);
            string = dataInputStream.readUTF();
            string = !string2.equals(string) ? string : null;
            bl2 = bl2 || string != null;
            this.addressInfo.setField(16, string);
            string = dataInputStream.readUTF();
            string = !string2.equals(string) ? string : null;
            bl2 = bl2 || string != null;
            this.addressInfo.setField(17, string);
            if (!bl2) {
                this.addressInfo = null;
            }
            if (dataInputStream != null) {
                dataInputStream.close();
                dataInputStream = null;
            }
            if (byteArrayInputStream != null) {
                byteArrayInputStream.close();
                byteArrayInputStream = null;
            }
        }
        catch (EOFException eOFException) {
            System.out.println("Error reading landmark field ");
            eOFException.printStackTrace();
            throw eOFException;
        }
        catch (IOException iOException) {
            System.out.println("Error reading landmark field " + string);
            iOException.printStackTrace();
            throw iOException;
        }
    }
}

