/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.location;

import com.nokia.phone.ri.location.Configuration;
import com.nokia.phone.ri.location.ProviderDelegate;
import com.nokia.phone.ri.location.ProximityNotifier;
import com.nokia.phone.ri.location.SecurityHandler;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.microedition.location.Coordinates;
import javax.microedition.location.Criteria;
import javax.microedition.location.Location;
import javax.microedition.location.LocationException;
import javax.microedition.location.LocationListener;
import javax.microedition.location.ProximityListener;

public abstract class LocationProvider {
    private static Hashtable storage = new Hashtable();
    private static ProximityNotifier proximityNotifier;
    public static final int AVAILABLE = 1;
    public static final int TEMPORARILY_UNAVAILABLE = 2;
    public static final int OUT_OF_SERVICE = 3;

    protected LocationProvider() {
    }

    public abstract int getState();

    public static LocationProvider getInstance(Criteria criteria) throws LocationException {
        Object object;
        Object object2;
        String string;
        String string2;
        String string3 = Configuration.getProperty((String)"microedition.location.providers");
        if (string3 == null) {
            throw new LocationException("Property javax.microedition.location.providers undefined");
        }
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        n4 = 0;
        while (n2 != -1) {
            n2 = string3.indexOf(44, n2 + 1);
            ++n4;
        }
        if (string3.trim().endsWith(",")) {
            --n4;
        }
        String[] stringArray = new String[n4];
        int n5 = 0;
        if (n4 == 0) {
            stringArray[0] = string3.trim();
        } else {
            n2 = 0;
            n3 = 0;
            while (n3 < n4) {
                n5 = n2;
                if ((n2 = string3.indexOf(44, n2 + 1)) != -1) {
                    string2 = string3.substring(n5, n2).trim();
                    if (!string2.startsWith(",")) {
                        stringArray[n3] = string2.trim();
                    } else {
                        string2 = string2.substring(1, string2.length());
                        stringArray[n3] = string2.trim();
                    }
                } else {
                    string2 = string3.substring(n5, string3.length());
                    if (!string2.startsWith(",")) {
                        stringArray[n3] = string2.trim();
                    } else {
                        string2 = string2.substring(1, string2.length());
                        stringArray[n3] = string2.trim();
                    }
                }
                ++n3;
            }
        }
        string2 = null;
        if (criteria == null) {
            string2 = stringArray[0];
            String string4 = Configuration.getProperty((String)(string2 + ".state"));
            if (!"OUT_OF_SERVICE".equals(string4)) {
                LocationProvider locationProvider = LocationProvider.findInstance(string2);
                if (locationProvider.getState() != 3) {
                    return locationProvider;
                }
                return null;
            }
            return null;
        }
        Vector<String> vector = new Vector<String>();
        Vector<String> vector2 = new Vector<String>();
        boolean bl2 = true;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        n3 = 0;
        while (n3 < stringArray.length) {
            boolean bl6;
            string = Configuration.getProperty((String)(stringArray[n3] + ".cost"));
            object2 = Configuration.getProperty((String)(stringArray[n3] + ".speedAndCourse"));
            object = Configuration.getProperty((String)(stringArray[n3] + ".addressInfo"));
            String string5 = Configuration.getProperty((String)(stringArray[n3] + ".altitude"));
            String string6 = Configuration.getProperty((String)(stringArray[n3] + ".horizontalAccuracy"));
            String string7 = Configuration.getProperty((String)(stringArray[n3] + ".verticalAccuracy"));
            String string8 = Configuration.getProperty((String)(stringArray[n3] + ".powerConsumption"));
            String string9 = Configuration.getProperty((String)(stringArray[n3] + ".maxResponseTime"));
            if (string != null && "false".equals(string)) {
                bl2 = false;
            }
            if (object2 != null && "true".equals(object2)) {
                bl3 = true;
            }
            if (object != null && "true".equals(object)) {
                bl5 = true;
            }
            if (string5 != null && "true".equals(string5)) {
                bl4 = true;
            }
            if (string6 != null) {
                n6 = Integer.valueOf(string6);
            }
            if (string7 != null) {
                n7 = Integer.valueOf(string7);
            }
            if (string8 != null) {
                try {
                    n8 = Integer.valueOf(string8);
                    if (n8 < 1 || n8 > 3) {
                        n8 = 0;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    n8 = "POWER_USAGE_LOW".equals(string8) ? 1 : ("POWER_USAGE_MEDIUM".equals(string8) ? 2 : ("POWER_USAGE_HIGH".equals(string8) ? 3 : 0));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (string9 != null) {
                n9 = Integer.valueOf(string9);
            }
            boolean bl7 = criteria.isAllowedToCost() || !criteria.isAllowedToCost() && !bl2;
            boolean bl8 = !criteria.isSpeedAndCourseRequired() || criteria.isSpeedAndCourseRequired() && bl3;
            boolean bl9 = !criteria.isAddressInfoRequired() || criteria.isAddressInfoRequired() && bl5;
            boolean bl10 = bl6 = !criteria.isAltitudeRequired() || criteria.isAltitudeRequired() && bl4;
            if (bl7 && bl8 && bl9 && bl6) {
                boolean bl11;
                vector.addElement(stringArray[n3]);
                boolean bl12 = criteria.getHorizontalAccuracy() <= 0 || criteria.getHorizontalAccuracy() > 0 && n6 <= criteria.getHorizontalAccuracy();
                boolean bl13 = criteria.getVerticalAccuracy() <= 0 || criteria.getVerticalAccuracy() > 0 && n7 <= criteria.getVerticalAccuracy();
                boolean bl14 = criteria.getPreferredPowerConsumption() <= 0 || criteria.getPreferredPowerConsumption() > 0 && n8 <= criteria.getPreferredPowerConsumption();
                boolean bl15 = bl11 = criteria.getPreferredResponseTime() <= 0 || criteria.getPreferredResponseTime() > 0 && n9 <= criteria.getPreferredResponseTime();
                if (bl12 && bl13 && bl14 && bl11) {
                    vector2.addElement(stringArray[n3]);
                }
            }
            ++n3;
        }
        if (vector.isEmpty()) {
            int n10 = 0;
            while (n10 < stringArray.length) {
                string2 = stringArray[n10];
                object2 = Configuration.getProperty((String)(string2 + ".state"));
                if (!"OUT_OF_SERVICE".equals(object2) && ((LocationProvider)(object = LocationProvider.findInstance(stringArray[n10]))).getState() != 3) {
                    return null;
                }
                ++n10;
            }
            object2 = "No provider available or temporarily unavailable";
            throw new LocationException((String)object2);
        }
        if (vector2.isEmpty()) {
            int n11 = 0;
            while (n11 < stringArray.length) {
                string2 = stringArray[n11];
                object2 = Configuration.getProperty((String)(string2 + ".state"));
                if (!"OUT_OF_SERVICE".equals(object2) && ((LocationProvider)(object = LocationProvider.findInstance(stringArray[n11]))).getState() != 3) {
                    return null;
                }
                ++n11;
            }
            object2 = "No provider available or temporarily unavailable";
            throw new LocationException((String)object2);
        }
        n3 = 0;
        while (n3 < vector2.size()) {
            string2 = (String)vector2.elementAt(n3);
            string = Configuration.getProperty((String)(string2 + ".state"));
            if (!"OUT_OF_SERVICE".equals(string) && ((LocationProvider)(object2 = LocationProvider.findInstance(string2))).getState() != 3) {
                string2 = (String)vector2.firstElement();
                return object2;
            }
            ++n3;
        }
        throw new LocationException();
    }

    private static LocationProvider findInstance(String string) {
        Object v2 = storage.get(string);
        if (v2 == null) {
            return LocationProvider.createProvider(string);
        }
        LocationProvider locationProvider = (LocationProvider)v2;
        if (locationProvider.getState() == 3) {
            storage.remove(v2);
            v2 = null;
            System.gc();
            locationProvider = LocationProvider.createProvider(string);
            return locationProvider;
        }
        return (LocationProvider)v2;
    }

    private static LocationProvider createProvider(String string) {
        if (string != null) {
            try {
                Class<?> clazz = Class.forName(string);
                Class<?> clazz2 = Class.forName("javax.microedition.location.LocationProvider");
                if (clazz2.isAssignableFrom(clazz)) {
                    Object obj = clazz.newInstance();
                    storage.put(string, obj);
                    return (LocationProvider)obj;
                }
                return null;
            }
            catch (ClassNotFoundException classNotFoundException) {
                return null;
            }
            catch (InstantiationException instantiationException) {
                return null;
            }
            catch (IllegalAccessException illegalAccessException) {
                return null;
            }
        }
        return null;
    }

    public abstract Location getLocation(int var1) throws LocationException, InterruptedException;

    public abstract void setLocationListener(LocationListener var1, int var2, int var3, int var4);

    public abstract void reset();

    public static Location getLastKnownLocation() {
        SecurityHandler.checkForPermission((String)"javax.microedition.location.Location");
        return ProviderDelegate.getLocation();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void addProximityListener(ProximityListener proximityListener, Coordinates coordinates, float f2) throws LocationException {
        SecurityHandler.checkForPermission((String)"javax.microedition.location.ProximityListener");
        if (Float.isNaN(f2)) throw new IllegalArgumentException();
        if (f2 <= 0.0f) {
            throw new IllegalArgumentException();
        }
        if (coordinates == null) {
            throw new NullPointerException();
        }
        if (proximityNotifier == null || !proximityNotifier.isAlive()) {
            proximityNotifier = new ProximityNotifier();
        }
        proximityNotifier.addListener(proximityListener, coordinates, f2);
        try {
            LocationProvider locationProvider;
            int n2;
            Object v2;
            if (storage == null) {
                LocationProvider.getInstance(null);
                return;
            }
            Enumeration enumeration = storage.elements();
            if (!enumeration.hasMoreElements()) {
                LocationProvider.getInstance(null);
                return;
            }
            do {
                if (enumeration.hasMoreElements()) continue;
                return;
            } while ((v2 = enumeration.nextElement()) == null || (n2 = (locationProvider = (LocationProvider)v2).getState()) != 1 && n2 != 2);
            LocationProvider.getInstance(null);
            return;
        }
        catch (LocationException locationException) {
            // empty catch block
        }
    }

    public static void removeProximityListener(ProximityListener proximityListener) {
        if (proximityListener == null) {
            return;
        }
        if (proximityNotifier != null) {
            proximityNotifier.removeListener(proximityListener);
        }
    }

    static {
        ProviderDelegate.setProviderStorage((Hashtable)storage);
    }
}

