/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.location;

import com.nokia.phone.ri.location.SecurityHandler;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Vector;
import javax.microedition.location.Landmark;
import javax.microedition.location.LandmarkException;
import javax.microedition.rms.InvalidRecordIDException;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordFilter;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;
import javax.microedition.rms.RecordStoreFullException;
import javax.microedition.rms.RecordStoreNotFoundException;
import javax.microedition.rms.RecordStoreNotOpenException;

public class LandmarkStore {
    private static LandmarkStore theInstance = null;
    private static Vector instanceVec = null;
    private RecordStore rs = null;
    private static RecordStore lookupRs = null;
    private String STORENAME;
    private static String DEFAULT_STORENAME = "LandmarkStore";
    private static String DB_LOOKUP_STORE = "Store_lookup";
    private static String vendor = "Nokia Mobile Phones";
    private static String suite = "Location";
    private int CATEGORY_RID = -1;
    private int STORE_UID = -1;
    private static int HIGHEST_UID_RID = -1;
    CategoryEnumeration supportedCategoryEnum = null;
    boolean supportedCategoryEnumDirty = false;

    private LandmarkStore() {
    }

    private LandmarkStore(String string) {
        this.STORENAME = string;
        try {
            byte[] byArray;
            Object object;
            int n2 = -1;
            int n3 = -1;
            if (string == DEFAULT_STORENAME) {
                this.rs = RecordStore.openRecordStore((String)DEFAULT_STORENAME, (String)vendor, (String)suite);
            } else {
                object = lookupRs.enumerateRecords(null, null, false);
                while (object.hasNextElement()) {
                    int n4 = -1;
                    try {
                        n4 = object.nextRecordId();
                        byArray = lookupRs.getRecord(n4);
                        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                        DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
                        String string2 = dataInputStream.readUTF();
                        n2 = dataInputStream.readInt();
                        if (!string2.equals(string)) continue;
                        n3 = n4;
                        break;
                    }
                    catch (EOFException eOFException) {
                        if (HIGHEST_UID_RID != -1 || n4 == -1) continue;
                        HIGHEST_UID_RID = n4;
                    }
                }
                if (n3 == -1) {
                    throw new IOException("Storage name for " + string + " not found!");
                }
                this.rs = RecordStore.openRecordStore((String)("LS-" + n3), (String)vendor, (String)suite);
            }
            if (this.rs.getNumRecords() == 0) {
                object = new ByteArrayOutputStream();
                DataOutputStream dataOutputStream = new DataOutputStream((OutputStream)object);
                dataOutputStream.writeLong(0L);
                byArray = ((ByteArrayOutputStream)object).toByteArray();
                this.CATEGORY_RID = this.rs.addRecord(byArray, 0, byArray.length);
                this.STORE_UID = n2;
            } else {
                if (string == DEFAULT_STORENAME) {
                    this.STORE_UID = 0;
                } else if (n2 != -1) {
                    this.STORE_UID = n2;
                }
                this.CATEGORY_RID = this.findCategoryRID();
            }
        }
        catch (IOException iOException) {
        }
        catch (RecordStoreFullException recordStoreFullException) {
        }
        catch (RecordStoreNotFoundException recordStoreNotFoundException) {
        }
        catch (RecordStoreException recordStoreException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * Unable to fully structure code
     */
    private int findCategoryRID() {
        var1_1 = null;
        try {
            var1_1 = this.rs.enumerateRecords(null, null, false);
        }
        catch (RecordStoreNotOpenException var2_2) {
            return -1;
        }
        if (var1_1 != null) ** GOTO lbl34
        return -1;
lbl-1000:
        // 1 sources

        {
            var2_3 = -1;
            var3_4 = null;
            try {
                var2_3 = var1_1.nextRecordId();
                var3_4 = this.rs.getRecord(var2_3);
                var4_5 = new ByteArrayInputStream(var3_4);
                var5_7 = new DataInputStream(var4_5);
                var6_9 = var5_7.readUTF();
                var7_11 = var5_7.readLong();
                var9_13 = var5_7.readUTF();
                var10_15 = var5_7.readDouble();
                var12_16 = var5_7.readDouble();
                continue;
            }
            catch (EOFException var4_6) {
                return var2_3;
            }
            catch (IOException var5_8) {
                return var2_3;
            }
            catch (RecordStoreNotOpenException var6_10) {
                return -1;
            }
            catch (InvalidRecordIDException var7_12) {
                return -1;
            }
            catch (RecordStoreException var8_17) {
                return -1;
            }
            catch (NullPointerException var9_14) {
                return -1;
            }
lbl34:
            // 2 sources

            ** while (var1_1.hasNextElement())
        }
lbl35:
        // 1 sources

        return -1;
    }

    public static LandmarkStore getInstance(String string) {
        int n2;
        SecurityHandler.checkForPermission((String)"javax.microedition.location.LandmarkStore.read");
        if (string == null) {
            if (theInstance == null) {
                theInstance = new LandmarkStore(DEFAULT_STORENAME);
            }
            if (LandmarkStore.theInstance.rs != null) {
                return theInstance;
            }
            return null;
        }
        if (instanceVec != null) {
            boolean bl2 = false;
            n2 = 0;
            while (n2 < instanceVec.size() && !bl2) {
                LandmarkStore landmarkStore = (LandmarkStore)instanceVec.elementAt(n2);
                if (landmarkStore != null && landmarkStore.getName().equals(string)) {
                    return landmarkStore;
                }
                ++n2;
            }
        } else {
            instanceVec = new Vector();
        }
        if (string != null) {
            try {
                String[] stringArray = LandmarkStore.listLandmarkStores();
                n2 = 0;
                int n3 = 0;
                while (n3 < stringArray.length) {
                    if (string.equals(stringArray[n3])) {
                        n2 = 1;
                    }
                    ++n3;
                }
                if (n2 == 0) {
                    return null;
                }
            }
            catch (IOException iOException) {
                return null;
            }
        }
        try {
            LandmarkStore landmarkStore = new LandmarkStore(string);
            if (landmarkStore.rs == null) {
                return null;
            }
            instanceVec.addElement(landmarkStore);
            return landmarkStore;
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static void createLandmarkStore(String string) throws IOException, LandmarkException {
        SecurityHandler.checkForPermission((String)"javax.microedition.location.LandmarkStore.management");
        if (string == null) {
            throw new NullPointerException("Store name must not be null");
        }
        if (string.equals("null")) {
            throw new NullPointerException("Store name must not be \"null\"");
        }
        if (lookupRs == null) {
            try {
                lookupRs = RecordStore.openRecordStore((String)DB_LOOKUP_STORE, (String)vendor, (String)suite);
            }
            catch (RecordStoreFullException recordStoreFullException) {
            }
            catch (RecordStoreNotFoundException recordStoreNotFoundException) {
            }
            catch (RecordStoreException recordStoreException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (lookupRs == null) {
                throw new IOException("The lookup store could not be opened.");
            }
        }
        int n2 = -1;
        n2 = LandmarkStore.findIndexRid(string, false);
        if (n2 != -1) {
            throw new IllegalArgumentException("Name " + string + " already exists");
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            n2 = LandmarkStore.findIndexRid(string, true);
            int n3 = LandmarkStore.findHighestUID();
            dataOutputStream.writeUTF(string);
            dataOutputStream.writeInt(n3 == -1 ? 1 : n3 + 1);
            if (n2 == -1) {
                throw new IOException("Can't create new LandmarkStore because storage space is full.");
            }
            byte[] byArray = byteArrayOutputStream.toByteArray();
            lookupRs.setRecord(n2, byArray, 0, byArray.length);
            ByteArrayOutputStream byteArrayOutputStream2 = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream2 = new DataOutputStream(byteArrayOutputStream2);
            dataOutputStream2.writeInt(n3 == -1 ? 1 : n3 + 1);
            byte[] byArray2 = byteArrayOutputStream2.toByteArray();
            lookupRs.setRecord(HIGHEST_UID_RID, byArray2, 0, byArray2.length);
            if (n2 == -1) {
                throw new IOException("Can't create new LandmarkStore because storage space is full.");
            }
            String string2 = "LS-" + n2;
            RecordStore recordStore = RecordStore.openRecordStore((String)string2, (String)vendor, (String)suite);
            recordStore.closeRecordStore();
            if (dataOutputStream != null) {
                dataOutputStream.close();
                dataOutputStream = null;
            }
            if (byteArrayOutputStream != null) {
                byteArrayOutputStream.close();
                byteArrayOutputStream = null;
            }
        }
        catch (RecordStoreException recordStoreException) {
            throw new IOException();
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IllegalArgumentException("Name " + string + " already exists");
        }
        catch (Exception exception) {
            throw new IOException();
        }
    }

    private static int findIndexRid(String string, boolean bl2) throws IOException {
        int n2 = -1;
        try {
            RecordEnumeration recordEnumeration = lookupRs.enumerateRecords(null, null, false);
            ByteArrayInputStream byteArrayInputStream = null;
            DataInputStream dataInputStream = null;
            boolean bl3 = false;
            int n3 = -1;
            while (recordEnumeration.hasNextElement()) {
                n3 = recordEnumeration.nextRecordId();
                byte[] byArray = lookupRs.getRecord(n3);
                byteArrayInputStream = new ByteArrayInputStream(byArray);
                dataInputStream = new DataInputStream(byteArrayInputStream);
                try {
                    String string2 = dataInputStream.readUTF();
                    if (string2.equals(string)) {
                        if (bl2) continue;
                        n2 = n3;
                        continue;
                    }
                    if (n2 != -1 || !bl2 || !string2.equals("null")) continue;
                    n2 = n3;
                }
                catch (EOFException eOFException) {
                    if (HIGHEST_UID_RID != -1) continue;
                    HIGHEST_UID_RID = n3;
                }
            }
        }
        catch (InvalidRecordIDException invalidRecordIDException) {
            throw new IOException("Error searching for " + string);
        }
        catch (RecordStoreNotOpenException recordStoreNotOpenException) {
            throw new IOException("Error searching for " + string);
        }
        catch (RecordStoreException recordStoreException) {
            throw new IOException("Error searching for " + string);
        }
        return n2;
    }

    private static int findHighestUID() throws IOException {
        int n2 = -1;
        try {
            RecordEnumeration recordEnumeration = lookupRs.enumerateRecords(null, null, false);
            ByteArrayInputStream byteArrayInputStream = null;
            DataInputStream dataInputStream = null;
            boolean bl2 = false;
            int n3 = -1;
            while (recordEnumeration.hasNextElement()) {
                n3 = recordEnumeration.nextRecordId();
                byte[] byArray = lookupRs.getRecord(n3);
                byteArrayInputStream = new ByteArrayInputStream(byArray);
                dataInputStream = new DataInputStream(byteArrayInputStream);
                try {
                    String string = dataInputStream.readUTF();
                    int n4 = dataInputStream.readInt();
                }
                catch (EOFException eOFException) {
                    ByteArrayInputStream byteArrayInputStream2 = new ByteArrayInputStream(byArray);
                    DataInputStream dataInputStream2 = new DataInputStream(byteArrayInputStream2);
                    n2 = dataInputStream2.readInt();
                    HIGHEST_UID_RID = n3;
                    break;
                }
            }
        }
        catch (InvalidRecordIDException invalidRecordIDException) {
            throw new IOException("Error searching for highest UID");
        }
        catch (RecordStoreNotOpenException recordStoreNotOpenException) {
            throw new IOException("Error searching for highest UID");
        }
        catch (RecordStoreException recordStoreException) {
            throw new IOException("Error searching for highest UID");
        }
        return n2;
    }

    private static void emptyRecordStore(RecordStore recordStore) {
        try {
            RecordEnumeration recordEnumeration = recordStore.enumerateRecords(null, null, false);
            ByteArrayInputStream byteArrayInputStream = null;
            DataInputStream dataInputStream = null;
            while (recordEnumeration.hasNextElement()) {
                Object object;
                int n2 = recordEnumeration.nextRecordId();
                byte[] byArray = recordStore.getRecord(n2);
                byteArrayInputStream = new ByteArrayInputStream(byArray);
                dataInputStream = new DataInputStream(byteArrayInputStream);
                try {
                    String string = dataInputStream.readUTF();
                    long l2 = dataInputStream.readLong();
                    object = dataInputStream.readUTF();
                    double d2 = dataInputStream.readDouble();
                    double d3 = dataInputStream.readDouble();
                    recordStore.deleteRecord(n2);
                }
                catch (EOFException eOFException) {
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
                    dataOutputStream.writeLong(0L);
                    object = byteArrayOutputStream.toByteArray();
                    recordStore.setRecord(n2, (byte[])object, 0, ((Object)object).length);
                }
            }
        }
        catch (RecordStoreFullException recordStoreFullException) {
        }
        catch (RecordStoreNotFoundException recordStoreNotFoundException) {
        }
        catch (RecordStoreException recordStoreException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void deleteLandmarkStore(String string) throws IOException, LandmarkException {
        Object object;
        int n2;
        SecurityHandler.checkForPermission((String)"javax.microedition.location.LandmarkStore.management");
        if (string == null) {
            throw new NullPointerException("Store name must not be null");
        }
        if (string.equals("null")) {
            throw new NullPointerException("Store name must not be \"null\"");
        }
        int n3 = -1;
        if (instanceVec != null && instanceVec.size() != 0) {
            n2 = 0;
            int n4 = 0;
            while (n4 < instanceVec.size()) {
                object = (LandmarkStore)instanceVec.elementAt(n4);
                if (((LandmarkStore)object).getName().equals(string)) {
                    try {
                        if (((LandmarkStore)object).rs != null) {
                            LandmarkStore.emptyRecordStore(((LandmarkStore)object).rs);
                            ((LandmarkStore)object).rs.closeRecordStore();
                        }
                        ((LandmarkStore)object).rs = null;
                        object = null;
                        n3 = n4;
                    }
                    catch (RecordStoreNotFoundException recordStoreNotFoundException) {
                    }
                    catch (RecordStoreNotOpenException recordStoreNotOpenException) {
                    }
                    catch (RecordStoreException recordStoreException) {
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                ++n4;
            }
        }
        try {
            if (n3 > -1) {
                instanceVec.removeElementAt(n3);
            } else {
                n2 = LandmarkStore.findIndexRid(string, false);
                if (n2 != -1) {
                    String string2 = "LS-" + n2;
                    object = RecordStore.openRecordStore((String)string2, (String)vendor, (String)suite);
                    LandmarkStore.emptyRecordStore((RecordStore)object);
                }
            }
            n2 = 0;
            RecordEnumeration recordEnumeration = lookupRs.enumerateRecords(null, null, false);
            object = null;
            DataInputStream dataInputStream = null;
            while (recordEnumeration.hasNextElement()) {
                n2 = recordEnumeration.nextRecordId();
                byte[] byArray = lookupRs.getRecord(n2);
                object = new ByteArrayInputStream(byArray);
                dataInputStream = new DataInputStream((InputStream)object);
                try {
                    String string3 = dataInputStream.readUTF();
                    int n5 = dataInputStream.readInt();
                    if (!string.equals(string3)) continue;
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
                    dataOutputStream.writeUTF("null");
                    dataOutputStream.writeInt(-1);
                    byte[] byArray2 = byteArrayOutputStream.toByteArray();
                    lookupRs.setRecord(n2, byArray2, 0, byArray2.length);
                }
                catch (EOFException eOFException) {
                    if (HIGHEST_UID_RID != -1) continue;
                    HIGHEST_UID_RID = n2;
                }
            }
        }
        catch (RecordStoreFullException recordStoreFullException) {
            throw new IOException();
        }
        catch (RecordStoreNotOpenException recordStoreNotOpenException) {
            throw new IOException();
        }
        catch (RecordStoreException recordStoreException) {
            throw new IOException();
        }
        catch (NullPointerException nullPointerException) {
            throw nullPointerException;
        }
        catch (Exception exception) {
            throw new SecurityException();
        }
    }

    public static String[] listLandmarkStores() throws IOException {
        SecurityHandler.checkForPermission((String)"javax.microedition.location.LandmarkStore.read");
        if (lookupRs == null) {
            try {
                lookupRs = RecordStore.openRecordStore((String)DB_LOOKUP_STORE, (String)vendor, (String)suite);
            }
            catch (RecordStoreFullException recordStoreFullException) {
            }
            catch (RecordStoreNotFoundException recordStoreNotFoundException) {
            }
            catch (RecordStoreException recordStoreException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (lookupRs == null) {
                return null;
            }
        }
        String[] stringArray = null;
        int n2 = 0;
        try {
            int n3;
            n2 = lookupRs.getNumRecords();
            if (n2 < 1) {
                return null;
            }
            String[] stringArray2 = new String[n2];
            int n4 = 0;
            ByteArrayInputStream byteArrayInputStream = null;
            DataInputStream dataInputStream = null;
            RecordEnumeration recordEnumeration = lookupRs.enumerateRecords(null, null, false);
            while (recordEnumeration.hasNextElement()) {
                n3 = recordEnumeration.nextRecordId();
                byte[] byArray = lookupRs.getRecord(n3);
                byteArrayInputStream = new ByteArrayInputStream(byArray);
                dataInputStream = new DataInputStream(byteArrayInputStream);
                try {
                    String string = dataInputStream.readUTF();
                    int n5 = dataInputStream.readInt();
                    if (string == null || string.equals("null")) continue;
                    stringArray2[n4] = string;
                    ++n4;
                }
                catch (EOFException eOFException) {
                    if (HIGHEST_UID_RID != -1) continue;
                    HIGHEST_UID_RID = n3;
                }
            }
            if (n4 > 0) {
                stringArray = new String[n4];
                n3 = 0;
                while (n3 < n4) {
                    stringArray[n3] = stringArray2[n3];
                    ++n3;
                }
            }
            return stringArray;
        }
        catch (RecordStoreFullException recordStoreFullException) {
            throw new IOException();
        }
        catch (RecordStoreNotOpenException recordStoreNotOpenException) {
            throw new IOException();
        }
        catch (RecordStoreException recordStoreException) {
            throw new IOException();
        }
        catch (NullPointerException nullPointerException) {
            throw new IOException();
        }
        catch (SecurityException securityException) {
            throw new SecurityException();
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new IOException();
        }
    }

    private String getName() {
        return this.STORENAME;
    }

    public void addLandmark(Landmark landmark, String string) throws IOException {
        SecurityHandler.checkForPermission((String)"javax.microedition.location.LandmarkStore.write");
        if (!this.checkCategory(string)) {
            throw new IllegalArgumentException("Category " + string + " not supported");
        }
        if (landmark == null) {
            throw new NullPointerException("Landmark was null");
        }
        boolean bl2 = this.existsInStore(landmark);
        if (bl2) {
            byte[] byArray = null;
            long l2 = landmark.getCategoryBits();
            landmark.setCategoryBits(l2 | this.lookupCategoryBit(string));
            byArray = landmark.getBytes();
            if (byArray != null && byArray.length > 0) {
                try {
                    int n2 = landmark.getId();
                    this.rs.setRecord(n2, byArray, 0, byArray.length);
                }
                catch (RecordStoreFullException recordStoreFullException) {
                    throw new IOException();
                }
                catch (RecordStoreNotOpenException recordStoreNotOpenException) {
                    throw new IOException();
                }
                catch (RecordStoreException recordStoreException) {
                    throw new IOException();
                }
                catch (NullPointerException nullPointerException) {
                    throw nullPointerException;
                }
                catch (SecurityException securityException) {
                    throw new SecurityException();
                }
            }
        } else {
            byte[] byArray = null;
            long l3 = landmark.getCategoryBits();
            landmark.setCategoryBits(this.lookupCategoryBit(string));
            byArray = landmark.getBytes();
            if (byArray != null && byArray.length > 0) {
                try {
                    int n3 = this.rs.addRecord(byArray, 0, byArray.length);
                    landmark.setId(n3);
                    landmark.setStoreId(this.STORE_UID);
                }
                catch (RecordStoreFullException recordStoreFullException) {
                    throw new IOException();
                }
                catch (RecordStoreNotOpenException recordStoreNotOpenException) {
                    throw new IOException();
                }
                catch (RecordStoreException recordStoreException) {
                    throw new IOException();
                }
                catch (NullPointerException nullPointerException) {
                    throw nullPointerException;
                }
                catch (SecurityException securityException) {
                    throw new SecurityException();
                }
            }
        }
    }

    public Enumeration getLandmarks(String string, String string2) throws IOException {
        if (this.rs == null) {
            throw new IOException("Database does not exist.");
        }
        try {
            LandmarkFilter landmarkFilter = new LandmarkFilter(string, string2);
            RecordEnumeration recordEnumeration = this.rs.enumerateRecords((RecordFilter)landmarkFilter, null, false);
            LandmarkEnumeration landmarkEnumeration = new LandmarkEnumeration(recordEnumeration);
            if (landmarkEnumeration.hasMoreElements()) {
                return landmarkEnumeration;
            }
            return null;
        }
        catch (RecordStoreNotOpenException recordStoreNotOpenException) {
            throw new IOException();
        }
        catch (RecordStoreException recordStoreException) {
            throw new IOException();
        }
    }

    public Enumeration getLandmarks() throws IOException {
        if (this.rs == null) {
            throw new IOException("Database does not exist.");
        }
        try {
            LandmarkFilter landmarkFilter = new LandmarkFilter(null, null);
            RecordEnumeration recordEnumeration = this.rs.enumerateRecords((RecordFilter)landmarkFilter, null, false);
            if (recordEnumeration.hasNextElement()) {
                return new LandmarkEnumeration(recordEnumeration);
            }
            return null;
        }
        catch (RecordStoreNotOpenException recordStoreNotOpenException) {
            throw new IOException();
        }
        catch (RecordStoreException recordStoreException) {
            throw new IOException();
        }
    }

    public Enumeration getLandmarks(String string, double d2, double d3, double d4, double d5) throws IOException {
        if (d4 < -180.0 || d4 >= 180.0 || d5 < -180.0 || d5 >= 180.0 || d2 < -90.0 || d2 > 90.0 || d3 < -90.0 || d3 > 90.0 || d2 > d3) {
            throw new IllegalArgumentException();
        }
        try {
            LandmarkAreaFilter landmarkAreaFilter = new LandmarkAreaFilter(string, d4, d5, d2, d3);
            RecordEnumeration recordEnumeration = this.rs.enumerateRecords((RecordFilter)landmarkAreaFilter, null, false);
            if (recordEnumeration.hasNextElement()) {
                return new LandmarkEnumeration(recordEnumeration);
            }
            return null;
        }
        catch (RecordStoreNotOpenException recordStoreNotOpenException) {
            throw new IOException();
        }
        catch (RecordStoreException recordStoreException) {
            throw new IOException();
        }
    }

    public void removeLandmarkFromCategory(Landmark landmark, String string) throws IOException {
        SecurityHandler.checkForPermission((String)"javax.microedition.location.LandmarkStore.write");
        if (landmark == null) {
            throw new NullPointerException("Landmark was null");
        }
        if (string == null) {
            throw new NullPointerException("Category was null");
        }
        if (!this.checkCategory(string)) {
            return;
        }
        if (landmark.getId() == -1) {
            return;
        }
        if (landmark.getStoreId() != this.STORE_UID) {
            return;
        }
        boolean bl2 = this.existsInStore(landmark);
        if (!bl2) {
            return;
        }
        byte[] byArray = null;
        long l2 = landmark.getCategoryBits();
        landmark.setCategoryBits(l2 & (this.lookupCategoryBit(string) ^ 0xFFFFFFFFFFFFFFFFL));
        byArray = landmark.getBytes();
        if (byArray != null && byArray.length > 0) {
            try {
                this.rs.setRecord(landmark.getId(), byArray, 0, byArray.length);
            }
            catch (InvalidRecordIDException invalidRecordIDException) {
                throw new IOException();
            }
            catch (RecordStoreFullException recordStoreFullException) {
                throw new IOException();
            }
            catch (RecordStoreNotOpenException recordStoreNotOpenException) {
                throw new IOException();
            }
            catch (RecordStoreException recordStoreException) {
                throw new IOException();
            }
            catch (NullPointerException nullPointerException) {
                throw nullPointerException;
            }
            catch (SecurityException securityException) {
                throw new SecurityException();
            }
        }
    }

    private boolean existsInStore(Landmark landmark) {
        boolean bl2 = false;
        if (landmark.getStoreId() == this.STORE_UID) {
            try {
                byte[] byArray = this.rs.getRecord(landmark.getId());
                bl2 = true;
            }
            catch (RecordStoreNotOpenException recordStoreNotOpenException) {
                bl2 = false;
            }
            catch (InvalidRecordIDException invalidRecordIDException) {
                bl2 = false;
            }
            catch (RecordStoreException recordStoreException) {
                bl2 = false;
            }
        }
        return bl2;
    }

    public void updateLandmark(Landmark landmark) throws IOException, LandmarkException {
        SecurityHandler.checkForPermission((String)"javax.microedition.location.LandmarkStore.write");
        if (landmark == null) {
            throw new NullPointerException("Landmark was null");
        }
        if (landmark.getId() == -1) {
            throw new LandmarkException("Landmark not from this store.");
        }
        if (landmark.getStoreId() != this.STORE_UID) {
            throw new LandmarkException("Landmark not from this store.");
        }
        boolean bl2 = this.existsInStore(landmark);
        if (!bl2) {
            throw new LandmarkException("Landmark does not exist in this store.");
        }
        byte[] byArray = landmark.getBytes();
        if (byArray != null && byArray.length > 0) {
            try {
                this.rs.setRecord(landmark.getId(), byArray, 0, byArray.length);
            }
            catch (InvalidRecordIDException invalidRecordIDException) {
                throw new LandmarkException("Landmark " + landmark.getName() + " does not exist.");
            }
            catch (RecordStoreFullException recordStoreFullException) {
                throw new IOException();
            }
            catch (RecordStoreNotOpenException recordStoreNotOpenException) {
                throw new IOException();
            }
            catch (RecordStoreException recordStoreException) {
                throw new IOException();
            }
            catch (NullPointerException nullPointerException) {
                throw nullPointerException;
            }
            catch (SecurityException securityException) {
                throw new SecurityException();
            }
        }
    }

    public void deleteLandmark(Landmark landmark) throws IOException, LandmarkException {
        SecurityHandler.checkForPermission((String)"javax.microedition.location.LandmarkStore.write");
        if (landmark == null) {
            throw new NullPointerException("Landmark was null");
        }
        if (landmark.getId() == -1) {
            throw new LandmarkException("Landmark not from this store.");
        }
        if (landmark.getStoreId() != this.STORE_UID) {
            throw new LandmarkException("Landmark not from this store.");
        }
        ByteArrayInputStream byteArrayInputStream = null;
        FilterInputStream filterInputStream = null;
        try {
            int n2 = landmark.getId();
            this.rs.deleteRecord(n2);
        }
        catch (RecordStoreNotOpenException recordStoreNotOpenException) {
        }
        catch (RecordStoreNotFoundException recordStoreNotFoundException) {
        }
        catch (InvalidRecordIDException invalidRecordIDException) {
        }
        catch (RecordStoreException recordStoreException) {
            // empty catch block
        }
        try {
            if (filterInputStream != null) {
                filterInputStream.close();
                filterInputStream = null;
            }
            if (byteArrayInputStream != null) {
                byteArrayInputStream.close();
                byteArrayInputStream = null;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public Enumeration getCategories() {
        CategoryEnumeration categoryEnumeration = new CategoryEnumeration(this.rs);
        return categoryEnumeration;
    }

    public void addCategory(String string) throws LandmarkException, IOException {
        Object object;
        SecurityHandler.checkForPermission((String)"javax.microedition.location.LandmarkStore.category");
        if (string == null) {
            throw new NullPointerException("Category name must not be null");
        }
        if (string.equals("null")) {
            throw new NullPointerException("Category name must not be \"null\"");
        }
        CategoryEnumeration categoryEnumeration = new CategoryEnumeration(this.rs);
        int n2 = categoryEnumeration.getNumberOfCategories();
        long l2 = categoryEnumeration.getCategoryBits();
        String[] stringArray = new String[n2 + 1];
        int n3 = 0;
        long l3 = 1L;
        n3 = 0;
        while (n3 < 64) {
            if ((l2 & l3) == 0L) break;
            l3 <<= 1;
            ++n3;
        }
        stringArray[n3] = string;
        boolean bl2 = false;
        int n4 = 1;
        int n5 = 0;
        while (n5 < n2 + 1) {
            if (n5 != n3 && categoryEnumeration.hasMoreElements()) {
                object = (String)categoryEnumeration.nextElement();
                if (string.equals(object)) {
                    throw new IllegalArgumentException("Category " + string + " already exists");
                }
                stringArray[n5] = object;
                ++n4;
            }
            ++n5;
        }
        object = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            dataOutputStream.writeLong(l2 | l3);
            int n6 = 0;
            while (n6 < n2 + 1) {
                dataOutputStream.writeUTF(stringArray[n6]);
                ++n6;
            }
            object = byteArrayOutputStream.toByteArray();
            if (dataOutputStream != null) {
                dataOutputStream.close();
                dataOutputStream = null;
            }
            if (byteArrayOutputStream != null) {
                byteArrayOutputStream.close();
                byteArrayOutputStream = null;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            this.rs.setRecord(this.CATEGORY_RID, (byte[])object, 0, ((String)object).length);
            this.supportedCategoryEnumDirty = true;
        }
        catch (InvalidRecordIDException invalidRecordIDException) {
            throw new IOException();
        }
        catch (RecordStoreFullException recordStoreFullException) {
            throw new IOException();
        }
        catch (RecordStoreNotOpenException recordStoreNotOpenException) {
            throw new IOException();
        }
        catch (RecordStoreException recordStoreException) {
            throw new IOException();
        }
        catch (NullPointerException nullPointerException) {
            throw new IOException();
        }
        catch (SecurityException securityException) {
            throw new SecurityException();
        }
    }

    /*
     * Unable to fully structure code
     */
    public void deleteCategory(String var1_1) throws LandmarkException, IOException {
        block22: {
            SecurityHandler.checkForPermission((String)"javax.microedition.location.LandmarkStore.category");
            if (var1_1 == null) {
                throw new NullPointerException("Category name must not be null");
            }
            if (var1_1.equals("null")) {
                throw new NullPointerException("Category name must not be \"null\"");
            }
            var2_2 = new CategoryEnumeration(this.rs);
            var3_3 = var2_2.getNumberOfCategories();
            var4_4 = var2_2.getCategoryBits();
            var6_5 = new String[var3_3];
            var7_6 = false;
            var8_7 = 0L;
            var10_8 = 0;
            var10_8 = 0;
            while (var10_8 < var3_3) {
                var11_9 = (String)var2_2.nextElement();
                if (var1_1.equals(var11_9)) {
                    var7_6 = true;
                    var12_10 = 1L;
                    var14_14 = 0;
                    var15_17 = 1;
                    while (var15_17 < 64) {
                        if ((var4_4 & var12_10) > 0L && ++var14_14 == var10_8 + 1) {
                            var8_7 = var12_10;
                            break;
                        }
                        var12_10 <<= 1;
                        ++var15_17;
                    }
                    var6_5[var10_8] = null;
                } else {
                    var6_5[var10_8] = var11_9;
                }
                ++var10_8;
            }
            if (!var7_6) {
                return;
            }
            var11_9 = this.getLandmarks(var1_1, null);
            if (var11_9 != null && var11_9.hasMoreElements()) ** GOTO lbl43
            break block22;
lbl-1000:
            // 1 sources

            {
                var12_12 = (Landmark)var11_9.nextElement();
                var13_19 = var12_12.getCategoryBits();
                if ((var13_19 & var8_7) <= 0L) continue;
                var12_12.setCategoryBits(var13_19 & (var8_7 ^ -1L));
                this.updateLandmark(var12_12);
lbl43:
                // 3 sources

                ** while (var11_9.hasMoreElements())
            }
        }
        var12_13 = null;
        try {
            var13_20 = new ByteArrayOutputStream();
            var14_15 = new DataOutputStream(var13_20);
            var14_15.writeLong(var4_4 & (var8_7 ^ -1L));
            var15_17 = 0;
            while (var15_17 < var3_3) {
                if (var6_5[var15_17] != null && !var6_5[var15_17].equals("null")) {
                    var14_15.writeUTF(var6_5[var15_17]);
                }
                ++var15_17;
            }
            var12_13 = var13_20.toByteArray();
            if (var14_15 != null) {
                var14_15.close();
                var14_15 = null;
            }
            if (var13_20 != null) {
                var13_20.close();
                var13_20 = null;
            }
        }
        catch (IOException var13_21) {
            // empty catch block
        }
        try {
            this.rs.setRecord(this.CATEGORY_RID, var12_13, 0, var12_13.length);
            this.supportedCategoryEnumDirty = true;
        }
        catch (InvalidRecordIDException var13_22) {
            throw new IOException();
        }
        catch (RecordStoreFullException var14_16) {
            throw new IOException();
        }
        catch (RecordStoreNotOpenException var15_18) {
            throw new IOException();
        }
        catch (RecordStoreException var16_23) {
            throw new IOException();
        }
        catch (NullPointerException var17_24) {
            throw new IOException();
        }
        catch (SecurityException var18_25) {
            throw new SecurityException();
        }
    }

    private boolean checkCategory(String string) {
        if (string != null) {
            long l2 = this.lookupCategoryBit(string);
            return l2 > 0L;
        }
        return true;
    }

    private boolean lookupCategory(long l2, String string) {
        if (string == null) {
            return true;
        }
        long l3 = this.lookupCategoryBit(string);
        return (l3 & l2) > 0L;
    }

    private long lookupCategoryBit(String string) {
        if (string == null) {
            return 0L;
        }
        if (this.supportedCategoryEnum == null || this.supportedCategoryEnumDirty) {
            this.supportedCategoryEnum = new CategoryEnumeration(this.rs);
            this.supportedCategoryEnumDirty = false;
        }
        this.supportedCategoryEnum.reset();
        long l2 = 1L;
        while (this.supportedCategoryEnum.hasMoreElements()) {
            String string2 = (String)this.supportedCategoryEnum.nextElement();
            if (string.equals(string2)) {
                return l2;
            }
            l2 <<= 1;
        }
        return 0L;
    }

    private class CategoryEnumeration
    implements Enumeration {
        String[] categoryArray = null;
        int currentIndex = -1;
        RecordStore store = null;
        int numberOfCategories = 0;
        long catBits = 0L;

        public CategoryEnumeration(RecordStore recordStore) {
            this.store = recordStore;
            ByteArrayInputStream byteArrayInputStream = null;
            FilterInputStream filterInputStream = null;
            try {
                byte[] byArray = recordStore.getRecord(LandmarkStore.this.CATEGORY_RID);
                byteArrayInputStream = new ByteArrayInputStream(byArray);
                filterInputStream = new DataInputStream(byteArrayInputStream);
                this.catBits = ((DataInputStream)filterInputStream).readLong();
                long l2 = 1L;
                int n2 = 1;
                while (n2 < 64) {
                    if ((this.catBits & l2) > 0L) {
                        ++this.numberOfCategories;
                    }
                    l2 <<= 1;
                    ++n2;
                }
                this.categoryArray = new String[this.numberOfCategories];
                int n3 = 0;
                while (n3 < this.numberOfCategories) {
                    this.categoryArray[n3] = ((DataInputStream)filterInputStream).readUTF();
                    ++n3;
                }
            }
            catch (IOException iOException) {
            }
            catch (RecordStoreNotOpenException recordStoreNotOpenException) {
            }
            catch (InvalidRecordIDException invalidRecordIDException) {
            }
            catch (RecordStoreException recordStoreException) {
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (filterInputStream != null) {
                    filterInputStream.close();
                    filterInputStream = null;
                }
                if (byteArrayInputStream != null) {
                    byteArrayInputStream.close();
                    byteArrayInputStream = null;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public boolean hasMoreElements() {
            return this.currentIndex < this.categoryArray.length - 1;
        }

        public Object nextElement() {
            if (this.hasMoreElements()) {
                ++this.currentIndex;
                return this.categoryArray[this.currentIndex];
            }
            throw new NoSuchElementException("End of category enumeration reached");
        }

        public void reset() {
            this.currentIndex = -1;
        }

        public int getNumberOfCategories() {
            return this.numberOfCategories;
        }

        public long getCategoryBits() {
            return this.catBits;
        }
    }

    class LandmarkEnumeration
    implements Enumeration {
        RecordStore store;
        RecordEnumeration re;
        String category = null;

        public LandmarkEnumeration(RecordStore recordStore) {
            this.store = recordStore;
            try {
                this.re = recordStore.enumerateRecords(null, null, false);
            }
            catch (RecordStoreNotOpenException recordStoreNotOpenException) {
                // empty catch block
            }
        }

        public LandmarkEnumeration(RecordEnumeration recordEnumeration) {
            this.re = recordEnumeration;
        }

        public boolean hasMoreElements() {
            return this.re.hasNextElement();
        }

        public Object nextElement() {
            try {
                int n2 = this.re.nextRecordId();
                if (n2 == LandmarkStore.this.CATEGORY_RID) {
                    throw new NoSuchElementException();
                }
                try {
                    Landmark landmark = new Landmark(LandmarkStore.this.rs.getRecord(n2));
                    landmark.setId(n2);
                    landmark.setStoreId(LandmarkStore.this.STORE_UID);
                    return landmark;
                }
                catch (IOException iOException) {
                    throw new NoSuchElementException();
                }
            }
            catch (InvalidRecordIDException invalidRecordIDException) {
                throw new NoSuchElementException();
            }
            catch (RecordStoreNotOpenException recordStoreNotOpenException) {
                throw new NoSuchElementException();
            }
            catch (RecordStoreException recordStoreException) {
                throw new NoSuchElementException();
            }
            catch (Exception exception) {
                throw new NoSuchElementException();
            }
        }
    }

    class LandmarkFilter
    implements RecordFilter {
        String category = null;
        String name = null;
        boolean result = false;

        public LandmarkFilter(String string, String string2) {
            this.category = string;
            this.name = string2;
        }

        public boolean matches(byte[] byArray) {
            ByteArrayInputStream byteArrayInputStream = null;
            FilterInputStream filterInputStream = null;
            String string = null;
            try {
                this.result = false;
                byteArrayInputStream = new ByteArrayInputStream(byArray);
                filterInputStream = new DataInputStream(byteArrayInputStream);
                string = ((DataInputStream)filterInputStream).readUTF();
                long l2 = ((DataInputStream)filterInputStream).readLong();
                String string2 = ((DataInputStream)filterInputStream).readUTF();
                double d2 = ((DataInputStream)filterInputStream).readDouble();
                double d3 = ((DataInputStream)filterInputStream).readDouble();
                if ("null".equals(string)) {
                    string = null;
                }
                boolean bl2 = false;
                bl2 = this.name == null || this.name != null && this.name.equals(string);
                boolean bl3 = false;
                bl3 = this.category == null ? true : LandmarkStore.this.lookupCategory(l2, this.category);
                if (bl2 && bl3) {
                    this.result = true;
                }
            }
            catch (EOFException eOFException) {
                this.result = false;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                if (filterInputStream != null) {
                    filterInputStream.close();
                    filterInputStream = null;
                }
                if (byteArrayInputStream != null) {
                    byteArrayInputStream.close();
                    byteArrayInputStream = null;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return this.result;
        }
    }

    class LandmarkAreaFilter
    implements RecordFilter {
        String category = null;
        double minLongitude;
        double maxLongitude;
        double minLatitude;
        double maxLatitude;
        boolean result = false;

        public LandmarkAreaFilter(String string, double d2, double d3, double d4, double d5) {
            this.category = string;
            this.minLongitude = d2;
            this.maxLongitude = d3;
            this.minLatitude = d4;
            this.maxLatitude = d5;
        }

        public boolean matches(byte[] byArray) {
            ByteArrayInputStream byteArrayInputStream = null;
            FilterInputStream filterInputStream = null;
            try {
                byteArrayInputStream = new ByteArrayInputStream(byArray);
                filterInputStream = new DataInputStream(byteArrayInputStream);
                String string = ((DataInputStream)filterInputStream).readUTF();
                long l2 = ((DataInputStream)filterInputStream).readLong();
                String string2 = ((DataInputStream)filterInputStream).readUTF();
                double d2 = ((DataInputStream)filterInputStream).readDouble();
                double d3 = ((DataInputStream)filterInputStream).readDouble();
                boolean bl2 = false;
                bl2 = this.category == null ? true : LandmarkStore.this.lookupCategory(l2, this.category);
                if (this.minLongitude > this.maxLongitude) {
                    boolean bl3;
                    boolean bl4 = d3 >= this.minLongitude && d3 < 180.0 || d3 >= -180.0 && d3 <= this.maxLongitude;
                    boolean bl5 = bl3 = d2 >= this.minLatitude && d2 <= this.maxLatitude;
                    this.result = bl2 && bl4 && bl3;
                } else {
                    this.result = bl2 && d3 >= this.minLongitude && d3 <= this.maxLongitude && d2 >= this.minLatitude && d2 <= this.maxLatitude;
                }
            }
            catch (EOFException eOFException) {
                this.result = false;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                if (filterInputStream != null) {
                    filterInputStream.close();
                    filterInputStream = null;
                }
                if (byteArrayInputStream != null) {
                    byteArrayInputStream.close();
                    byteArrayInputStream = null;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return this.result;
        }
    }
}

